<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Counter_Odometer'))) {
		class WPBakeryShortCode_TS_VCSC_Counter_Odometer extends WPBakeryShortCode {};
	};
	$VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                      	=> __( "TS Counter Odometer", "ts_visual_composer_extend" ),
		"base"                      	=> "TS_VCSC_Counter_Odometer",
		"icon" 	                   	 	=> "ts-composer-element-icon-counter-odometer",
		"category"                  	=> __( "Composium", "ts_visual_composer_extend" ),
		"description"               	=> __("Place an odometer counter element", "ts_visual_composer_extend"),
		"admin_enqueue_js"				=> "",
		"admin_enqueue_css"				=> "",
		"params"                    	=> array(
			// General Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_1",
				"seperator"				=> "General Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Start Function", "ts_visual_composer_extend" ),
				"param_name"			=> "odometer_start_dynamic",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you want to use a shortcode to generate the start value for the counter.", "ts_visual_composer_extend" ),
			),
			array(
				"type"             	 	=> "textfield",
				"heading"           	=> __( "Odometer: Start Value", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_start_value",
				"value"             	=> "",
				"description"       	=> __( "Define the start value for the odometer counter.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_start_dynamic", 'value' => 'false' ),
			),
			array(
				"type"              	=> "textarea_raw_html",
				"heading"           	=> __( "Odometer: Start Value", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_start_shortcode",
				"value"             	=> base64_encode(""),
				"description"       	=> __( "Enter the shortcode that will dynamically generate the counter start value.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_start_dynamic", 'value' => 'true' ),
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: End Function", "ts_visual_composer_extend" ),
				"param_name"			=> "odometer_end_dynamic",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you want to use a shortcode to generate the end value for the counter.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Odometer: End Value", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_end_value",
				"value"             	=> "",
				"description"       	=> __( "Define the end value for the odometer counter.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_end_dynamic", 'value' => 'false' ),
			),
			array(
				"type"              	=> "textarea_raw_html",
				"heading"           	=> __( "Odometer: End Value", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_end_shortcode",
				"value"             	=> base64_encode(""),
				"description"       	=> __( "Enter the shortcode that will dynamically generate the counter end value.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_end_dynamic", 'value' => 'true' ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Odometer: Format", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_format",
				"width"             	=> 150,
				"value"             	=> array(
					__( "No Format", "ts_visual_composer_extend" )						=> "none",
					__( "Thousand Separator (Comma)", "ts_visual_composer_extend" )		=> "comma",
					__( "Thousand Separator (Dot)", "ts_visual_composer_extend" )		=> "dot",
					__( "Thousand Separator (Space)", "ts_visual_composer_extend" )		=> "space",
				),
				"description"       	=> __( "Select the theme to be used for the odometer counter.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Simple Count", "ts_visual_composer_extend" ),
				"param_name"			=> "odometer_simple",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you only want to use a basic non-odometer like count animation.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Odometer: Animation Minimum", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_limit",
				"value"             	=> "360",
				"min"               	=> "0",
				"max"               	=> "1024",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define a minimum screen width that is required to show the odometer animation; otherwise, a simple count will be used.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_simple", 'value' => 'false' ),
			),	
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Odometer: Animation Delay", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_delay",
				"value"             	=> "500",
				"min"               	=> "0",
				"max"               	=> "10000",
				"step"              	=> "100",
				"unit"              	=> 'ms',
				"description"       	=> __( "Define an optional delay for the odometer animation.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Viewport Trigger", "ts_visual_composer_extend" ),
				"param_name"			=> "odometer_viewport",
				"value"					=> "true",
				"description"       	=> __( "Switch the toggle if you want to start the odometer count only after the element comes into browser view.", "ts_visual_composer_extend" ),
			),
			// Odometer Message
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_2",
				"seperator"				=> "Odometer Message",
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Message Output", "ts_visual_composer_extend" ),
				"param_name"			=> "content_output",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you want to add a short message below the odometer counter.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           	=> __( "Odometer: Message Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "content_message",
				"minimal"				=> "true",
				"value"             	=> base64_encode(""),
				"description"      	 	=> __( "Enter a short message to be shown below the odometer; basic HTML code can be used.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_output", 'value' => 'true' ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Odometer: Message Spacing", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_spacing",
				"value"             	=> "20",
				"min"               	=> "0",
				"max"               	=> "60",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the spacing between the message and the odometer counter.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_output", 'value' => 'true' ),
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Message Frame", "ts_visual_composer_extend" ),
				"param_name"			=> "content_frame",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you want to add a border and padding to the message.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_output", 'value' => 'true' ),
			),
			array(
				"type" 					=> "advanced_styling",
				"heading" 				=> __("Odometer: Message Border", "ts_visual_composer_extend"),
				"param_name" 			=> "content_border",
				"style_type"			=> "border",
				"show_main"				=> "false",
				"show_preview"			=> "true",
				"show_width"			=> "true",
				"show_style"			=> "true",
				"show_radius" 			=> "true",					
				"show_color"			=> "true",
				"show_unit_width"		=> "true",
				"show_unit_radius"		=> "true",
				"override_all"			=> "true",
				"default_positions"		=> array(
					"All"							=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Top"							=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Right"							=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Bottom"						=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Left"							=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
				),
				"description"       	=> __( "Define the border settings for each side and corner of the odometer message.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_frame", 'value' => 'true' ),
			),
			array(
				"type" 					=> "advanced_styling",
				"heading" 				=> __("Odometer: Message Paddings", "ts_visual_composer_extend"),
				"param_name" 			=> "content_padding",
				"style_type"			=> "padding",
				"show_main"				=> "false",
				"show_preview"			=> "false",
				"show_width"			=> "true",
				"show_style"			=> "false",
				"show_radius" 			=> "false",					
				"show_color"			=> "false",
				"show_unit_width"		=> "false",
				"show_unit_radius"		=> "false",
				"label_width"			=> "",
				"override_all"			=> "false",
				"default_positions"		=> array(
					//"All"							=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Top"							=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Right"							=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Bottom"						=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Left"							=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
				),
				"value"					=> "padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;",
				"description"       	=> __( "Define the internal paddings for the odometer message.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "content_frame", 'value' => 'true' ),
			),
			// Style Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_3",
				"seperator"				=> "Style Settings",
				"group" 				=> "Style Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Odometer: Theme", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_theme",
				"width"             	=> 150,
				"value"             	=> array(
					__( "No Theme", "ts_visual_composer_extend" )						=> "default",
					__( "Minimal", "ts_visual_composer_extend" )						=> "minimal",
					__( "Digital", "ts_visual_composer_extend" )						=> "digital",
					__( "Car", "ts_visual_composer_extend" )							=> "car",
					__( "Plaza", "ts_visual_composer_extend" )							=> "plaza",
					__( "Slot Machine", "ts_visual_composer_extend" )					=> "slot-machine",
					__( "Train Station", "ts_visual_composer_extend" )					=> "train-station",
				),
				"admin_label"			=> true,
				"description"       	=> __( "Select the theme to be used for the odometer counter.", "ts_visual_composer_extend" ),
				"group" 				=> "Style Settings",
			),			
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Odometer: Fill Zeroes", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_fillup",
				"value"            	 	=> "true",
				"description"       	=> __( "Switch the toggle if you want to fill the start value for the odometer with zeroes.", "ts_visual_composer_extend" ),
				"group" 				=> "Style Settings",
			),			
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Odometer: Font Size", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_size",
				"value"             	=> "36",
				"min"               	=> "10",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the font size that should be used for the odometer.", "ts_visual_composer_extend" ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Odometer: Text Align", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_align",
				"width"             	=> 150,
				"value"             	=> array(
					__( "Center", "ts_visual_composer_extend" )                        	=> "center",
					__( "Left", "ts_visual_composer_extend" )                          	=> "left",
					__( "Right", "ts_visual_composer_extend" )                         	=> "right",
				),
				"description"       	=> __( "Select how the odometer should be aligned within the column.", "ts_visual_composer_extend" ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Odometer: Customize", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_custom",
				"value"            	 	=> "false",
				"description"       	=> __( "Switch the toggle if you want to customize the odometer styling beyond the theme defaults.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_theme", 'value' => array('default', 'minimal', 'plaza') ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"					=> "fontsmanager",
				"heading"				=> __( "Odometer: Font Family", "ts_visual_composer_extend" ),
				"param_name"			=> "odometer_family",
				"value"					=> "",
				"default"				=> "true",
				"connector"				=> "odometer_type",
				"description"			=> __( "Select the font to be used for the odometer numbers.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_custom", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"					=> "hidden_input",
				"param_name"			=> "odometer_type",
				"value"					=> "",
				"dependency"        	=> array( 'element' => "odometer_custom", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Odometer: Numbers Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_color",
				"value"             	=> "#696969",
				"description"       	=> __( "Define the color of the odometer numbers.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "odometer_custom", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Odometer: Numbers Background", "ts_visual_composer_extend" ),
				"param_name"        	=> "odometer_background",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Define the background color for the odometer numbers.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "odometer_custom", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Column Width", "ts_visual_composer_extend" ),
				"param_name"			=> "odometer_columnwide",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you want the odometer to use the full column width.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "odometer_custom", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Numbers Frame", "ts_visual_composer_extend" ),
				"param_name"			=> "odometer_frame",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you want to add a border and padding to the message.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "odometer_custom", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),
			array(
				"type" 					=> "advanced_styling",
				"heading" 				=> __("Odometer: Numbers Border", "ts_visual_composer_extend"),
				"param_name" 			=> "odometer_border",
				"style_type"			=> "border",
				"show_main"				=> "false",
				"show_preview"			=> "true",
				"show_width"			=> "true",
				"show_style"			=> "true",
				"show_radius" 			=> "true",					
				"show_color"			=> "true",
				"show_unit_width"		=> "true",
				"show_unit_radius"		=> "true",
				"override_all"			=> "true",
				"default_positions"		=> array(
					"All"							=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Top"							=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Right"							=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Bottom"						=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Left"							=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
				),
				"description"       	=> __( "Define the border settings for each side and corner of the odometer numbers.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_frame", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),
			array(
				"type" 					=> "advanced_styling",
				"heading" 				=> __("Odometer: Numbers Paddings", "ts_visual_composer_extend"),
				"param_name" 			=> "odometer_padding",
				"style_type"			=> "padding",
				"show_main"				=> "false",
				"show_preview"			=> "false",
				"show_width"			=> "true",
				"show_style"			=> "false",
				"show_radius" 			=> "false",					
				"show_color"			=> "false",
				"show_unit_width"		=> "false",
				"show_unit_radius"		=> "false",
				"label_width"			=> "",
				"override_all"			=> "false",
				"default_positions"		=> array(
					//"All"							=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Top"							=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Right"							=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Bottom"						=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Left"							=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
				),
				"value"					=> "padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;",
				"description"       	=> __( "Define the internal paddings for the odometer numbers.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "odometer_frame", 'value' => 'true' ),
				"group" 				=> "Style Settings",
			),			
			// Icon/Image Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_4",
				"seperator"				=> "Icon Settings",
				"group" 				=> "Icon Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Odometer: Icon Type", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_type",
				"width"             	=> 150,
				"value"             	=> array(
					__( 'No Icon', "ts_visual_composer_extend" )		=> "none",
					__( 'Font Icon', "ts_visual_composer_extend" )		=> "font",
					__( 'Image Icon', "ts_visual_composer_extend" )		=> "image",
				),
				"description"       	=> __( "Select the type of icon you want to add to the odometer.", "ts_visual_composer_extend" ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Odometer: Icon Position", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_position",
				"width"             	=> 150,
				"value"             	=> array(
					__( 'Top', "ts_visual_composer_extend" )          => "top",
					__( 'Bottom', "ts_visual_composer_extend" )       => "bottom",
				),
				"description"       	=> __( "Select where the icon should be positioned in relation to the odometer.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "icon_type", 'value' => array('font', 'image') ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type" 					=> "icons_panel",
				'heading' 				=> __( 'Odometer: Font Icon', 'ts_visual_composer_extend' ),
				'param_name' 			=> 'icon_font',
				'value'					=> '',
				"settings" 				=> array(
					"emptyIcon" 				=> false,
					'emptyIconValue'			=> 'transparent',
					"type" 						=> 'extensions',
				),
				"description"       	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon you want to display.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"        	=> array( 'element' => "icon_type", 'value' => 'font' ),
				"group" 				=> "Icon Settings",
			),			
			array(
				"type"              	=> "attach_image",
				"heading"           	=> __( "Odometer: Image Icon", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_image",
				"value"             	=> "",
				"description"       	=> __( "Image must have equal dimensions for scaling purposes (i.e. 100x100).", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "icon_type", 'value' => 'image' ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Odometer: Icon Size", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_size",
				"value"             	=> "64",
				"min"               	=> "16",
				"max"               	=> "512",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the icon / image size.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "icon_type", 'value' => array('font', 'image') ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Odometer: Icon Spacing", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_spacing",
				"value"             	=> "20",
				"min"               	=> "0",
				"max"               	=> "60",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the spacing between the icon and the odometer counter.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "icon_type", 'value' => array('font', 'image') ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Odometer: Icon Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_color",
				"value"             	=> "#cccccc",
				"description"       	=> __( "Define the color of the icon.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "icon_type", 'value' => 'font' ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Odometer: Icon Background", "ts_visual_composer_extend" ),
				"param_name"        	=> "icon_background",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Define the background color for the icon / transparent image.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "icon_type", 'value' => array('font', 'image') ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Odometer: Icon Frame", "ts_visual_composer_extend" ),
				"param_name"			=> "icon_frame",
				"value"					=> "false",
				"description"       	=> __( "Switch the toggle if you want to add a border and padding to the icon.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "icon_type", 'value' => array('font', 'image') ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type" 					=> "advanced_styling",
				"heading" 				=> __("Odometer: Icon Border", "ts_visual_composer_extend"),
				"param_name" 			=> "icon_border",
				"style_type"			=> "border",
				"show_main"				=> "false",
				"show_preview"			=> "true",
				"show_width"			=> "true",
				"show_style"			=> "true",
				"show_radius" 			=> "true",					
				"show_color"			=> "true",
				"show_unit_width"		=> "true",
				"show_unit_radius"		=> "true",
				"override_all"			=> "true",
				"default_positions"		=> array(
					"All"							=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Top"							=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Right"							=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Bottom"						=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Left"							=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
				),
				"description"       	=> __( "Define the border settings for each side and corner of the icon.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "icon_frame", 'value' => 'true' ),
				"group" 				=> "Icon Settings",
			),
			array(
				"type" 					=> "advanced_styling",
				"heading" 				=> __("Odometer: Icon Paddings", "ts_visual_composer_extend"),
				"param_name" 			=> "icon_padding",
				"style_type"			=> "padding",
				"show_main"				=> "false",
				"show_preview"			=> "false",
				"show_width"			=> "true",
				"show_style"			=> "false",
				"show_radius" 			=> "false",					
				"show_color"			=> "false",
				"show_unit_width"		=> "false",
				"show_unit_radius"		=> "false",
				"label_width"			=> "",
				"override_all"			=> "false",
				"default_positions"		=> array(
					//"All"							=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "1", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Top"							=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Right"							=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Bottom"						=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Left"							=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
				),
				"value"					=> "padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;",
				"description"       	=> __( "Define the internal paddings for the icon.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "icon_frame", 'value' => 'true' ),
				"group" 				=> "Icon Settings",
			),
			// Tooltip Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_5",
				"seperator"            	=> "Tooltip Settings",
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Tooltip Addition", "ts_visual_composer_extend" ),
				"param_name"        	=> "tooltip_usage",
				"value"            	 	=> "false",
				"description"       	=> __( "Switch the toggle if you want to add an optional tooltip to the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"              	=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           	=> __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "tooltip_content",
				"minimal"				=> "true",
				"value"             	=> base64_encode(""),
				"description"      	 	=> __( "Enter the tooltip content for the element; basic HTML code can be used.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Tooltip Arrow", "ts_visual_composer_extend" ),
				"param_name"        	=> "tooltip_arrow",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle to either show or hide the tooltip arrow.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Tooltip Position", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltip_position",
				"value"					=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Positions,
				"description"			=> __( "Select the tooltip position in relation to the element.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"				    => "dropdown",
				"heading"			    => __( "Tooltip Animation", "ts_visual_composer_extend" ),
				"param_name"		    => "tooltip_animation",
				"value"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Animations,
				"description"		    => __( "Select how the tooltip entry and exit should be animated once triggered.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group"					=> "Tooltip Settings",
			),	
			array(
				"type"					=> "dropdown",
				"heading"				=> __( "Tooltip Style", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltip_style",
				"value"             	=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Styles,
				"description"			=> __( "Select the tooltip style.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Tooltip Font Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "tooltip_color",
				"value"             	=> "#ffffff",
				"description"       	=> __( "Define the custom font color for the tooltip.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tooltip_style", 'value' => array('tooltipster-custom', 'ts-simptip-style-custom') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Tooltip Settings",
			),		
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Tooltip Background Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "tooltip_background",
				"value"             	=> "#000000",
				"description"       	=> __( "Define the custom background color for the tooltip.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tooltip_style", 'value' => array('tooltipster-custom', 'ts-simptip-style-custom') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"              	=> "colorpicker",
				"heading"           	=> __( "Tooltip Border Color", "ts_visual_composer_extend" ),
				"param_name"        	=> "tooltip_border",
				"value"             	=> "#000000",
				"description"       	=> __( "Define the custom border color for the tooltip.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tooltip_style", 'value' => array('tooltipster-custom', 'ts-simptip-style-custom') ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"group" 				=> "Tooltip Settings",
			),	
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltip_offsetx",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
				"param_name"			=> "tooltip_offsety",
				"value"					=> "0",
				"min"					=> "-100",
				"max"					=> "100",
				"step"					=> "1",
				"unit"					=> 'px',
				"description"			=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 				=> "Tooltip Settings",
			),
			// Viewport Animation
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_6",
				"seperator"				=> "Viewport Entry Animation",
				"group" 				=> "Other Settings",
			),
			array(
				"type"					=> "css3animations",
				"heading"				=> __("Viewport Animation: Effect", "ts_visual_composer_extend"),
				"param_name"			=> "viewport_class",
				"prefix"				=> "ts-viewport-css-",
				"connector"				=> "viewport_name",
				"noneselect"			=> "true",
				"default"				=> "",
				"value"					=> "",
				"description"			=> __("Select an optional viewport entry animation for the overall element, shown before the odometer starts.", "ts_visual_composer_extend"),
				"group" 				=> "Other Settings",
			),
			array(
				"type"					=> "hidden_input",
				"heading"				=> __( "Viewport Animation: Effect", "ts_visual_composer_extend" ),
				"param_name"			=> "viewport_name",
				"value"					=> "",
				"group" 				=> "Other Settings",
			),
			array(
				"type"					=> "nouislider",
				"heading"				=> __( "Viewport Animation: Delay", "ts_visual_composer_extend" ),
				"param_name"			=> "viewport_delay",
				"value"					=> "0",
				"min"					=> "0",
				"max"					=> "20000",
				"step"					=> "100",
				"unit"					=> 'ms',
				"description"			=> __( "Define how long the viewport animation should be delayed after it has been triggered.", "ts_visual_composer_extend" ),
				"dependency"			=> array("element" => "viewport_class", "not_empty" => true),
				"group" 				=> "Other Settings",
			),
			array(
				"type" 					=> "viewport_offset",
				"heading" 				=> __( "Viewport Animation: Offset", "ts_visual_composer_extend"),
				"param_name" 			=> "viewport_offset",
				"value" 				=> 'bottom-in-view',
				"description" 			=> __("Define the offset (top of screen) that should trigger the viewport animation.", "ts_visual_composer_extend"),
				"dependency"			=> array("element" => "viewport_class", "not_empty" => true),
				"group" 				=> "Other Settings",
			),			
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Viewport Animation: Minimum", "ts_visual_composer_extend" ),
				"param_name"        	=> "viewport_limit",
				"value"             	=> "360",
				"min"               	=> "0",
				"max"               	=> "1024",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define a minimum screen width that is required to show the viewport animation.", "ts_visual_composer_extend" ),
				"dependency"			=> array("element" => "viewport_class", "not_empty" => true),
				"group" 				=> "Other Settings",
			),
			// Other Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_7",
				"seperator"             => "Other Settings",
				"group" 				=> "Other Settings",
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"        	=> "margin_top",
				"value"             	=> "0",
				"min"               	=> "-50",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"             	 	=> 'px',
				"description"       	=> __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"        	=> "margin_bottom",
				"value"             	=> "0",
				"min"               	=> "-50",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"        	=> "el_id",
				"value"             	=> "",
				"description"       	=> __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
			array(
				"type"                  => "tag_editor",
				"heading"           	=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"            => "el_class",
				"value"                 => "",
				"description"      		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group" 				=> "Other Settings",
			),
		)
	);	
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>